<?php

class Helper {
    
    public static function emptyOrRows($rows) {
        if (!$rows || !is_array($rows)) {
            return [];
        }
        return $rows;
    }
    
    public static function emptyOrObject($result) {
        if (!$result || !is_array($result) || count($result) === 0) {
            return null;
        }
        return $result[0];
    }
    
    public static function newFileName($fileName) {
        // Generate UUID v4
        $data = random_bytes(16);
        $data[6] = chr(ord($data[6]) & 0x0f | 0x40);
        $data[8] = chr(ord($data[8]) & 0x3f | 0x80);
        $uuid = vsprintf('%s%s-%s-%s-%s-%s%s%s', str_split(bin2hex($data), 4));
        
        $timestamp = round(microtime(true) * 1000);
        return "{$uuid}-{$timestamp}-{$fileName}";
    }
    
    public static function jsonResponse($data, $statusCode = 200) {
        http_response_code($statusCode);
        header('Content-Type: application/json; charset=utf-8');
        echo json_encode($data, JSON_UNESCAPED_UNICODE);
        exit;
    }
    
    public static function errorResponse($message, $statusCode = 500) {
        self::jsonResponse(['error' => $message], $statusCode);
    }
    
    public static function enableCors() {
        $origin = $_SERVER['HTTP_ORIGIN'] ?? '*';
        
        if (CORS_ALLOWED_ORIGINS === '*') {
            header("Access-Control-Allow-Origin: *");
        } else {
            $allowedOrigins = explode(',', CORS_ALLOWED_ORIGINS);
            if (in_array($origin, $allowedOrigins)) {
                header("Access-Control-Allow-Origin: $origin");
            }
        }
        
        header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS");
        header("Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With");
        header("Access-Control-Allow-Credentials: true");
        
        // Handle preflight requests
        if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
            http_response_code(200);
            exit;
        }
    }
    
    public static function getRequestBody() {
        $body = file_get_contents('php://input');
        return json_decode($body, true) ?? [];
    }
    
    public static function getQueryParam($key, $default = null) {
        return $_GET[$key] ?? $default;
    }
}

