<?php
require_once __DIR__ . '/../config.php';

class Database {
    private static $instance = null;
    private $connection = null;
    
    private function __construct() {
        // Private constructor to prevent direct instantiation
    }
    
    public static function getInstance() {
        if (self::$instance === null) {
            self::$instance = new self();
        }
        return self::$instance;
    }
    
    public function getConnection() {
        try {
            $dsn = "mysql:host=" . DB_HOST . ";port=" . DB_PORT . ";dbname=" . DB_NAME . ";charset=" . DB_CHARSET;
            $options = [
                PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
                PDO::ATTR_EMULATE_PREPARES => false,
            ];
            
            $connection = new PDO($dsn, DB_USER, DB_PASSWORD, $options);
            return $connection;
        } catch (PDOException $e) {
            error_log("Database Connection Error: " . $e->getMessage());
            throw new Exception("Database connection failed");
        }
    }
    
    public function query($sql, $params = []) {
        try {
            $connection = $this->getConnection();
            $stmt = $connection->prepare($sql);
            $stmt->execute($params);
            $results = $stmt->fetchAll();
            return $results;
        } catch (PDOException $e) {
            error_log("Query Error: " . $e->getMessage());
            throw new Exception("Database query failed: " . $e->getMessage());
        }
    }
    
    public function execute($sql, $params = []) {
        try {
            $connection = $this->getConnection();
            $stmt = $connection->prepare($sql);
            $result = $stmt->execute($params);
            return [
                'success' => $result,
                'rowCount' => $stmt->rowCount(),
                'insertId' => $connection->lastInsertId()
            ];
        } catch (PDOException $e) {
            error_log("Execute Error: " . $e->getMessage());
            throw new Exception("Database execute failed: " . $e->getMessage());
        }
    }
}

