<?php
require_once __DIR__ . '/../utils/Database.php';
require_once __DIR__ . '/../utils/Helper.php';

class SocialNetworksService {
    private $db;
    
    public function __construct() {
        $this->db = Database::getInstance();
    }
    
    public function getAll($onlyVisible = false) {
        $sql = "SELECT t1.id, t1.platform, t1.link, t1.networkOrder, t1.isVisible 
                FROM social_networks t1 
                INNER JOIN (
                    SELECT platform, MAX(id) AS max_id 
                    FROM social_networks 
                    GROUP BY platform
                ) t2 
                ON t1.platform = t2.platform AND t1.id = t2.max_id";
        
        if ($onlyVisible) {
            $sql .= " WHERE t1.isVisible = 1";
        }
        
        $sql .= " ORDER BY t1.networkOrder";
        
        $rows = $this->db->query($sql);
        return Helper::emptyOrRows($rows);
    }
    
    public function getSocialNetwork($id) {
        $sql = "SELECT * FROM social_networks WHERE id = ?";
        $rows = $this->db->query($sql, [$id]);
        return Helper::emptyOrObject($rows);
    }
    
    public function addSocialNetwork($data) {
        $sql = "INSERT INTO social_networks (id, platform, link, networkOrder, isVisible) 
                VALUES (NULL, ?, ?, ?, ?)";
        $params = [
            $data['platform'],
            $data['link'],
            $data['order'] ?? 0,
            $data['isVisible']
        ];
        $result = $this->db->execute($sql, $params);
        return $result['insertId'];
    }
    
    public function updateSocialNetwork($id, $data) {
        $sql = "UPDATE social_networks 
                SET networkOrder = ?, platform = ?, isVisible = ?, link = ?
                WHERE id = ?";
        $params = [
            $data['order'] ?? 0,
            $data['platform'],
            $data['isVisible'],
            $data['link'],
            $id
        ];
        return $this->db->execute($sql, $params);
    }
    
    public function deleteSocialNetwork($id) {
        $sql = "DELETE FROM social_networks WHERE id = ?";
        return $this->db->execute($sql, [$id]);
    }
}

