<?php
require_once __DIR__ . '/../utils/Database.php';
require_once __DIR__ . '/../utils/Helper.php';

class SeasonsService {
    private $db;
    
    public function __construct() {
        $this->db = Database::getInstance();
    }
    
    public function getSeasons($onlyVisible = false) {
        $sql = "SELECT se.*, s.name AS showName
                FROM seasons se JOIN shows s ON se.showId = s.id";
        if ($onlyVisible) {
            $sql .= " WHERE se.isVisible = 1";
        }
        $sql .= " ORDER BY se.seasonOrder";
        
        $rows = $this->db->query($sql);
        return Helper::emptyOrRows($rows);
    }
    
    public function getSeason($id) {
        $sql = "SELECT se.*, s.name AS showName
                FROM seasons se JOIN shows s ON se.showId = s.id AND se.id = ?";
        $rows = $this->db->query($sql, [$id]);
        return Helper::emptyOrObject($rows);
    }
    
    public function getSeasonsOfShow($id, $onlyVisible = false) {
        $sql = "SELECT se.*, s.name AS showName
                FROM seasons se JOIN shows s ON se.showId = s.id AND se.showId = ?";
        if ($onlyVisible) {
            $sql .= " AND se.isVisible = 1";
        }
        $sql .= " ORDER BY se.seasonOrder";
        
        $rows = $this->db->query($sql, [$id]);
        return Helper::emptyOrRows($rows);
    }
    
    public function getEpisodesOfSeason($id, $onlyVisible = false) {
        $sql = "SELECT e.*
                FROM episodes e JOIN seasons s ON e.seasonId = s.id AND s.id = ? 
                WHERE e.highlightOf IS NULL";
        if ($onlyVisible) {
            $sql .= " AND e.isVisible = 1";
        }
        
        $rows = $this->db->query($sql, [$id]);
        return Helper::emptyOrRows($rows);
    }
    
    public function addSeason($data) {
        $sql = "INSERT INTO seasons 
                (id, name, showId, seasonOrder, isVisible) 
                VALUES (NULL, ?, ?, ?, ?)";
        $params = [
            $data['name'],
            $data['showId'],
            $data['seasonOrder'] ?? 0,
            $data['isVisible']
        ];
        return $this->db->execute($sql, $params);
    }
    
    public function updateSeason($id, $data) {
        $sql = "UPDATE seasons 
                SET name = ?, seasonOrder = ?, isVisible = ?
                WHERE id = ?";
        $params = [
            $data['name'],
            $data['seasonOrder'] ?? 0,
            $data['isVisible'],
            $id
        ];
        return $this->db->execute($sql, $params);
    }
    
    public function deleteSeason($id) {
        $sql = "DELETE FROM seasons WHERE id = ?";
        return $this->db->execute($sql, [$id]);
    }
}

