<?php
require_once __DIR__ . '/../utils/Database.php';
require_once __DIR__ . '/../utils/Helper.php';

class SearchService {
    private $db;
    
    public function __construct() {
        $this->db = Database::getInstance();
    }
    
    public function getAll($keyword) {
        $result = ['shows' => [], 'episodes' => []];
        
        if (!$keyword || trim($keyword) === '') {
            return $result;
        }
        
        $searchTerm = '%' . trim($keyword) . '%';
        
        // Search shows
        $sql = "SELECT * FROM shows 
                WHERE isVisible = 1 AND (name LIKE ? OR presenterName LIKE ?)";
        $rows = $this->db->query($sql, [$searchTerm, $searchTerm]);
        $result['shows'] = Helper::emptyOrRows($rows);
        
        // Search episodes
        $sql = "SELECT * FROM episodes 
                WHERE isVisible = 1 AND (title LIKE ? OR guest LIKE ?)";
        $rows = $this->db->query($sql, [$searchTerm, $searchTerm]);
        $result['episodes'] = Helper::emptyOrRows($rows);
        
        return $result;
    }
}

