<?php
require_once __DIR__ . '/../utils/Database.php';
require_once __DIR__ . '/../utils/Helper.php';

class LiveService {
    private $db;
    
    public function __construct() {
        $this->db = Database::getInstance();
    }
    
    public function getLatest() {
        $sql = "SELECT * FROM live_links ORDER BY id DESC LIMIT 1";
        $rows = $this->db->query($sql);
        return Helper::emptyOrObject($rows);
    }
    
    public function update($link) {
        $sql = "INSERT INTO live_links (id, link) VALUES (NULL, ?)";
        $result = $this->db->execute($sql, [$link]);
        return $result['insertId'];
    }
    
    public function getLiveProgram($id) {
        $sql = "SELECT p.*, s.name, s.description, s.id as showId 
                FROM program_live p 
                JOIN shows s ON p.showId = s.id 
                WHERE p.id = ?";
        $rows = $this->db->query($sql, [$id]);
        return Helper::emptyOrObject($rows);
    }
    
    public function getAllLivePrograms() {
        $sql = "SELECT p.*, s.name, s.description 
                FROM program_live p 
                JOIN shows s ON p.showId = s.id";
        $rows = $this->db->query($sql);
        return Helper::emptyOrRows($rows);
    }
    
    public function getLivePrograms($checkIsActive = true) {
        $day = date('w'); // 0 (Sunday) to 6 (Saturday)
        
        $sql = "SELECT p.*, s.name, s.description 
                FROM program_live p 
                JOIN shows s ON p.showId = s.id 
                WHERE p.day = ?";
        
        $params = [$day];
        
        if ($checkIsActive) {
            $sql .= " AND p.isVisible = 1";
        }
        
        $rows = $this->db->query($sql, $params);
        return Helper::emptyOrRows($rows);
    }
    
    public function deleteLiveProgram($id) {
        $sql = "DELETE FROM program_live WHERE id = ?";
        return $this->db->execute($sql, [$id]);
    }
    
    public function updateLiveProgram($data) {
        $sql = "UPDATE program_live 
                SET showId = ?, day = ?, time = ?, isVisible = ?
                WHERE id = ?";
        $params = [
            $data['show'],
            $data['day'],
            $data['time'],
            $data['isVisible'],
            $data['id']
        ];
        return $this->db->execute($sql, $params);
    }
    
    public function addLiveProgram($data) {
        $sql = "INSERT INTO program_live (id, showId, time, day, isVisible)
                VALUES(NULL, ?, ?, ?, ?)";
        $params = [
            $data['show'],
            $data['time'],
            $data['day'],
            $data['isVisible']
        ];
        return $this->db->execute($sql, $params);
    }
}

