<?php
require_once __DIR__ . '/../utils/Database.php';
require_once __DIR__ . '/../utils/Helper.php';

class ChannelsService {
    private $db;
    
    public function __construct() {
        $this->db = Database::getInstance();
    }
    
    public function getChannels($onlyVisible = false) {
        $sql = "SELECT * FROM channels";
        if ($onlyVisible) {
            $sql .= " WHERE isVisible = 1";
        }
        $sql .= " ORDER BY channelOrder";
        
        $rows = $this->db->query($sql);
        return Helper::emptyOrRows($rows);
    }
    
    public function getChannel($id) {
        $sql = "SELECT * FROM channels WHERE id = ?";
        $rows = $this->db->query($sql, [$id]);
        return Helper::emptyOrObject($rows);
    }
}

