<?php
require_once __DIR__ . '/../utils/Database.php';
require_once __DIR__ . '/../utils/Helper.php';

class CategoriesService {
    private $db;
    
    public function __construct() {
        $this->db = Database::getInstance();
    }
    
    public function getCategories($onlyVisible = false) {
        $sql = "SELECT * FROM categories";
        if ($onlyVisible) {
            $sql .= " WHERE isVisible = 1";
        }
        $sql .= " ORDER BY categoryOrder";
        
        $rows = $this->db->query($sql);
        return Helper::emptyOrRows($rows);
    }
    
    public function getCategory($id) {
        $sql = "SELECT * FROM categories WHERE id = ?";
        $rows = $this->db->query($sql, [$id]);
        return Helper::emptyOrObject($rows);
    }
    
    public function getCategoriesOfShow($showId) {
        $sql = "SELECT categories.id, categories.name 
                FROM categories
                JOIN categories_shows ON categories_shows.categoryId = categories.id 
                WHERE categories_shows.showId = ?";
        $rows = $this->db->query($sql, [$showId]);
        return Helper::emptyOrRows($rows);
    }
    
    public function addCategory($data) {
        $sql = "INSERT INTO categories (id, name, categoryOrder, isVisible, thumbnailUrl) 
                VALUES (NULL, ?, ?, ?, ?)";
        $params = [
            $data['name'] ?? '',
            $data['order'] ?? 0,
            $data['isVisible'] ?? 1,
            $data['thumbnailUrl'] ?? ''
        ];
        return $this->db->execute($sql, $params);
    }
    
    public function updateCategory($id, $data) {
        $sql = "UPDATE categories 
                SET categoryOrder = ?, name = ?, isVisible = ?, thumbnailUrl = ? 
                WHERE id = ?";
        $params = [
            $data['order'] ?? 0,
            $data['name'] ?? '',
            $data['isVisible'] ?? 1,
            $data['thumbnailUrl'] ?? '',
            $id
        ];
        return $this->db->execute($sql, $params);
    }
    
    public function deleteCategory($id) {
        $sql = "DELETE FROM categories WHERE id = ?";
        return $this->db->execute($sql, [$id]);
    }
}

