<?php
require_once __DIR__ . '/config.php';
require_once __DIR__ . '/utils/Helper.php';

// Enable CORS
Helper::enableCors();

// Get the request URI and method
$uri = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);
$method = $_SERVER['REQUEST_METHOD'];

// Remove any trailing slashes
$uri = rtrim($uri, '/');

// Root healthcheck endpoint
if ($uri === '' || $uri === '/') {
    Helper::jsonResponse(['healthcheck' => 'ok']);
}

// File upload endpoint
if ($uri === '/upload' && $method === 'POST') {
    try {
        if (!isset($_FILES['image']) || $_FILES['image']['error'] === UPLOAD_ERR_NO_FILE) {
            Helper::errorResponse('No file is uploaded', 400);
        }
        
        $file = $_FILES['image'];
        
        if ($file['error'] !== UPLOAD_ERR_OK) {
            Helper::errorResponse('File upload error', 400);
        }
        
        $fileName = Helper::newFileName($file['name']);
        $uploadPath = STORAGE_PATH . '/' . $fileName;
        
        if (move_uploaded_file($file['tmp_name'], $uploadPath)) {
            Helper::jsonResponse(['fileName' => $fileName]);
        } else {
            Helper::errorResponse('Failed to save file', 500);
        }
    } catch (Exception $e) {
        error_log("Upload error: " . $e->getMessage());
        Helper::errorResponse('Upload failed', 500);
    }
}

// Route to appropriate API handler
if (strpos($uri, '/categories') === 0) {
    require __DIR__ . '/api/categories.php';
} else if (strpos($uri, '/shows') === 0) {
    require __DIR__ . '/api/shows.php';
} else if (strpos($uri, '/live') === 0) {
    require __DIR__ . '/api/live.php';
} else if (strpos($uri, '/socialnetworks') === 0) {
    require __DIR__ . '/api/socialnetworks.php';
} else if (strpos($uri, '/episodes') === 0) {
    require __DIR__ . '/api/episodes.php';
} else if (strpos($uri, '/seasons') === 0) {
    require __DIR__ . '/api/seasons.php';
} else if (strpos($uri, '/search') === 0) {
    require __DIR__ . '/api/search.php';
} else if (strpos($uri, '/channels') === 0) {
    require __DIR__ . '/api/channels.php';
} else {
    Helper::errorResponse('Endpoint not found', 404);
}

