<?php
require_once __DIR__ . '/../services/SocialNetworksService.php';
require_once __DIR__ . '/../utils/Helper.php';

$service = new SocialNetworksService();
$method = $_SERVER['REQUEST_METHOD'];
$uri = $_SERVER['REQUEST_URI'];

try {
    $uriParts = explode('/', trim(parse_url($uri, PHP_URL_PATH), '/'));
    $id = isset($uriParts[2]) && is_numeric($uriParts[2]) ? $uriParts[2] : null;
    
    if (!$id && isset($uriParts[3]) && is_numeric($uriParts[3])) {
        $id = $uriParts[3];
    }
    
    switch ($method) {
        case 'GET':
            if ($id) {
                // GET /socialnetworks/:id
                $result = $service->getSocialNetwork($id);
                Helper::jsonResponse($result);
            } else {
                // GET /socialnetworks
                $onlyVisible = Helper::getQueryParam('onlyVisible', false);
                $result = $service->getAll($onlyVisible);
                Helper::jsonResponse($result);
            }
            break;
            
        case 'POST':
            $body = Helper::getRequestBody();
            
            if (strpos($uri, '/add') !== false) {
                // POST /socialnetworks/add
                $id = $service->addSocialNetwork($body);
                $result = $service->getSocialNetwork($id);
                Helper::jsonResponse($result);
            } else if (strpos($uri, '/update') !== false && $id) {
                // POST /socialnetworks/update/:id
                $service->updateSocialNetwork($id, $body);
                Helper::jsonResponse(['success' => true]);
            } else {
                Helper::errorResponse('Invalid endpoint', 404);
            }
            break;
            
        case 'DELETE':
            if (strpos($uri, '/delete') !== false && $id) {
                // DELETE /socialnetworks/delete/:id
                $service->deleteSocialNetwork($id);
                Helper::jsonResponse(['success' => true]);
            } else {
                Helper::errorResponse('Invalid endpoint', 404);
            }
            break;
            
        default:
            Helper::errorResponse('Method not allowed', 405);
    }
} catch (Exception $e) {
    error_log("Error in social networks API: " . $e->getMessage());
    Helper::errorResponse($e->getMessage(), 500);
}

