<?php
require_once __DIR__ . '/../services/ShowsService.php';
require_once __DIR__ . '/../utils/Helper.php';

$service = new ShowsService();
$method = $_SERVER['REQUEST_METHOD'];
$uri = $_SERVER['REQUEST_URI'];

try {
    $uriParts = explode('/', trim(parse_url($uri, PHP_URL_PATH), '/'));
    $id = null;
    
    // Determine ID position based on URL structure
    if (isset($uriParts[2])) {
        if ($uriParts[2] === 'grouped') {
            // Special case for /shows/grouped
        } else if (is_numeric($uriParts[2])) {
            $id = $uriParts[2];
        } else if ($uriParts[2] === 'update' && isset($uriParts[3])) {
            $id = $uriParts[3];
        } else if ($uriParts[2] === 'delete' && isset($uriParts[3])) {
            $id = $uriParts[3];
        }
    }
    
    switch ($method) {
        case 'GET':
            if (strpos($uri, '/grouped') !== false) {
                // GET /shows/grouped
                $result = $service->getGroupedShows();
                Helper::jsonResponse($result);
            } else if ($id) {
                // GET /shows/:id
                $result = $service->getShow($id);
                Helper::jsonResponse($result);
            } else {
                // GET /shows
                $onlyVisible = Helper::getQueryParam('onlyVisible', false);
                $categoryId = Helper::getQueryParam('categoryId');
                $categories = Helper::getQueryParam('categories');
                
                $query = [];
                if ($categoryId) $query['categoryId'] = $categoryId;
                if ($categories) $query['categories'] = $categories;
                
                $result = $service->getShows($query, $onlyVisible);
                Helper::jsonResponse($result);
            }
            break;
            
        case 'POST':
            $body = Helper::getRequestBody();
            
            if (strpos($uri, '/show/add') !== false) {
                // POST /shows/show/add
                $service->addShow($body['show']);
                Helper::jsonResponse(['status' => 'success']);
            } else if (strpos($uri, '/update') !== false && $id) {
                // POST /shows/update/:id
                $service->updateShow($body['show']);
                Helper::jsonResponse(['status' => 'success']);
            } else {
                Helper::errorResponse('Invalid endpoint', 404);
            }
            break;
            
        case 'DELETE':
            if (strpos($uri, '/delete') !== false && $id) {
                // DELETE /shows/delete/:id
                $service->deleteShow($id);
                Helper::jsonResponse(['success' => true]);
            } else {
                Helper::errorResponse('Invalid endpoint', 404);
            }
            break;
            
        default:
            Helper::errorResponse('Method not allowed', 405);
    }
} catch (Exception $e) {
    error_log("Error in shows API: " . $e->getMessage());
    Helper::errorResponse($e->getMessage(), 500);
}

