<?php
require_once __DIR__ . '/../services/SeasonsService.php';
require_once __DIR__ . '/../utils/Helper.php';

$service = new SeasonsService();
$method = $_SERVER['REQUEST_METHOD'];
$uri = $_SERVER['REQUEST_URI'];

try {
    $uriParts = explode('/', trim(parse_url($uri, PHP_URL_PATH), '/'));
    
    switch ($method) {
        case 'GET':
            if (strpos($uri, '/show') !== false) {
                // GET /seasons/show/:id
                $id = isset($uriParts[3]) ? $uriParts[3] : null;
                $onlyVisible = Helper::getQueryParam('onlyVisible', false);
                $result = $service->getSeasonsOfShow($id, $onlyVisible);
                Helper::jsonResponse($result);
            } else if (strpos($uri, '/episodes') !== false) {
                // GET /seasons/episodes/:id
                $id = isset($uriParts[3]) ? $uriParts[3] : null;
                $onlyVisible = Helper::getQueryParam('onlyVisible', false);
                $result = $service->getEpisodesOfSeason($id, $onlyVisible);
                Helper::jsonResponse($result);
            } else {
                $id = isset($uriParts[2]) && is_numeric($uriParts[2]) ? $uriParts[2] : null;
                
                if ($id) {
                    // GET /seasons/:id
                    $result = $service->getSeason($id);
                    Helper::jsonResponse($result);
                } else {
                    // GET /seasons
                    $result = $service->getSeasons();
                    Helper::jsonResponse($result);
                }
            }
            break;
            
        case 'POST':
            $body = Helper::getRequestBody();
            
            if (strpos($uri, '/add') !== false) {
                // POST /seasons/add
                $service->addSeason($body);
                Helper::jsonResponse(['success' => true]);
            } else if (strpos($uri, '/update') !== false) {
                // POST /seasons/update/:id
                $id = isset($uriParts[3]) ? $uriParts[3] : null;
                $service->updateSeason($id, $body);
                Helper::jsonResponse(['success' => true]);
            } else {
                Helper::errorResponse('Invalid endpoint', 404);
            }
            break;
            
        case 'DELETE':
            if (strpos($uri, '/delete') !== false) {
                // DELETE /seasons/delete/:id
                $id = isset($uriParts[3]) ? $uriParts[3] : null;
                $service->deleteSeason($id);
                Helper::jsonResponse(['success' => true]);
            } else {
                Helper::errorResponse('Invalid endpoint', 404);
            }
            break;
            
        default:
            Helper::errorResponse('Method not allowed', 405);
    }
} catch (Exception $e) {
    error_log("Error in seasons API: " . $e->getMessage());
    Helper::errorResponse($e->getMessage(), 500);
}

