<?php
require_once __DIR__ . '/../services/SearchService.php';
require_once __DIR__ . '/../utils/Helper.php';

$service = new SearchService();
$method = $_SERVER['REQUEST_METHOD'];

try {
    if ($method === 'GET') {
        $keyword = Helper::getQueryParam('keyword');
        $result = $service->getAll($keyword);
        Helper::jsonResponse($result);
    } else {
        Helper::errorResponse('Method not allowed', 405);
    }
} catch (Exception $e) {
    error_log("Error in search API: " . $e->getMessage());
    Helper::errorResponse($e->getMessage(), 500);
}

