<?php
require_once __DIR__ . '/../services/LiveService.php';
require_once __DIR__ . '/../utils/Helper.php';

$service = new LiveService();
$method = $_SERVER['REQUEST_METHOD'];
$uri = $_SERVER['REQUEST_URI'];

try {
    $uriParts = explode('/', trim(parse_url($uri, PHP_URL_PATH), '/'));
    
    switch ($method) {
        case 'GET':
            if (strpos($uri, '/programs') !== false) {
                // GET /live/programs (get all)
                $result = $service->getAllLivePrograms();
                Helper::jsonResponse($result);
            } else if (strpos($uri, '/program') !== false) {
                $id = isset($uriParts[3]) && is_numeric($uriParts[3]) ? $uriParts[3] : null;
                
                if ($id) {
                    // GET /live/program/:id
                    $result = $service->getLiveProgram($id);
                    Helper::jsonResponse($result);
                } else {
                    // GET /live/program
                    $onlyActive = Helper::getQueryParam('onlyActive', true);
                    $result = $service->getLivePrograms($onlyActive);
                    Helper::jsonResponse($result);
                }
            } else {
                // GET /live
                $result = $service->getLatest();
                Helper::jsonResponse($result);
            }
            break;
            
        case 'POST':
            $body = Helper::getRequestBody();
            
            if (strpos($uri, '/program/update') !== false) {
                // POST /live/program/update/:id
                $id = isset($uriParts[4]) ? $uriParts[4] : null;
                $result = $service->updateLiveProgram($body['liveProgram']);
                Helper::jsonResponse($result);
            } else if (strpos($uri, '/add') !== false) {
                // POST /live/add
                $result = $service->addLiveProgram($body['liveProgram']);
                Helper::jsonResponse($result);
            } else if (strpos($uri, '/update') !== false) {
                // POST /live/update
                $result = $service->update($body['link']);
                Helper::jsonResponse($result);
            } else {
                Helper::errorResponse('Invalid endpoint', 404);
            }
            break;
            
        case 'DELETE':
            if (strpos($uri, '/delete') !== false) {
                // DELETE /live/delete/:id
                $id = isset($uriParts[3]) ? $uriParts[3] : null;
                if ($id) {
                    $service->deleteLiveProgram($id);
                    Helper::jsonResponse(['success' => true]);
                } else {
                    Helper::errorResponse('ID required', 400);
                }
            } else {
                Helper::errorResponse('Invalid endpoint', 404);
            }
            break;
            
        default:
            Helper::errorResponse('Method not allowed', 405);
    }
} catch (Exception $e) {
    error_log("Error in live API: " . $e->getMessage());
    Helper::errorResponse($e->getMessage(), 500);
}

