<?php
require_once __DIR__ . '/../services/EpisodesService.php';
require_once __DIR__ . '/../utils/Helper.php';

$service = new EpisodesService();
$method = $_SERVER['REQUEST_METHOD'];
$uri = $_SERVER['REQUEST_URI'];

try {
    $uriParts = explode('/', trim(parse_url($uri, PHP_URL_PATH), '/'));
    
    switch ($method) {
        case 'GET':
            if (strpos($uri, '/latest/all') !== false) {
                // GET /episodes/latest/all
                $result = $service->getLatest();
                Helper::jsonResponse($result);
            } else if (strpos($uri, '/latest/category') !== false) {
                // GET /episodes/latest/category/:id
                $id = isset($uriParts[4]) ? $uriParts[4] : null;
                $onlyVisible = Helper::getQueryParam('onlyVisible', false);
                $result = $service->getLatestEpisodeOfCategory($id, $onlyVisible);
                Helper::jsonResponse($result);
            } else if (strpos($uri, '/latest') !== false) {
                // GET /episodes/latest/:id
                $id = isset($uriParts[3]) ? $uriParts[3] : null;
                $onlyVisible = Helper::getQueryParam('onlyVisible', false);
                $result = $service->getLatestEpisodeOfShow($id, $onlyVisible);
                Helper::jsonResponse($result);
            } else if (strpos($uri, '/highlights') !== false) {
                // GET /episodes/highlights/:id
                $id = isset($uriParts[3]) ? $uriParts[3] : null;
                $onlyVisible = Helper::getQueryParam('onlyVisible', false);
                $result = $service->getHighlights($id, $onlyVisible);
                Helper::jsonResponse($result);
            } else if (strpos($uri, '/show') !== false) {
                // GET /episodes/show/:id
                $id = isset($uriParts[3]) ? $uriParts[3] : null;
                $onlyVisible = Helper::getQueryParam('onlyVisible', false);
                $result = $service->getEpisodesOfShow($id, $onlyVisible);
                Helper::jsonResponse($result);
            } else if (strpos($uri, '/category') !== false) {
                // GET /episodes/category/:id
                $id = isset($uriParts[3]) ? $uriParts[3] : null;
                $onlyVisible = Helper::getQueryParam('onlyVisible', false);
                $result = $service->getEpisodesOfCategory($id, $onlyVisible);
                Helper::jsonResponse($result);
            } else {
                $id = isset($uriParts[2]) && is_numeric($uriParts[2]) ? $uriParts[2] : null;
                
                if ($id) {
                    // GET /episodes/:id
                    $result = $service->getEpisode($id);
                    Helper::jsonResponse($result);
                } else {
                    // GET /episodes
                    $result = $service->getEpisodes();
                    Helper::jsonResponse($result);
                }
            }
            break;
            
        case 'POST':
            $body = Helper::getRequestBody();
            
            if (strpos($uri, '/add') !== false) {
                // POST /episodes/add
                $service->addEpisode($body);
                Helper::jsonResponse(['success' => true]);
            } else if (strpos($uri, '/update') !== false) {
                // POST /episodes/update/:id
                $id = isset($uriParts[3]) ? $uriParts[3] : null;
                $service->updateEpisode($id, $body);
                Helper::jsonResponse(['success' => true]);
            } else {
                Helper::errorResponse('Invalid endpoint', 404);
            }
            break;
            
        case 'DELETE':
            if (strpos($uri, '/delete') !== false) {
                // DELETE /episodes/delete/:id
                $id = isset($uriParts[3]) ? $uriParts[3] : null;
                $service->deleteEpisode($id);
                Helper::jsonResponse(['success' => true]);
            } else {
                Helper::errorResponse('Invalid endpoint', 404);
            }
            break;
            
        default:
            Helper::errorResponse('Method not allowed', 405);
    }
} catch (Exception $e) {
    error_log("Error in episodes API: " . $e->getMessage());
    Helper::errorResponse($e->getMessage(), 500);
}

