<?php
require_once __DIR__ . '/../services/ChannelsService.php';
require_once __DIR__ . '/../utils/Helper.php';

$service = new ChannelsService();
$method = $_SERVER['REQUEST_METHOD'];
$uri = $_SERVER['REQUEST_URI'];

try {
    $uriParts = explode('/', trim(parse_url($uri, PHP_URL_PATH), '/'));
    $id = isset($uriParts[2]) && is_numeric($uriParts[2]) ? $uriParts[2] : null;
    
    switch ($method) {
        case 'GET':
            if ($id) {
                // GET /channels/:id
                $result = $service->getChannel($id);
                Helper::jsonResponse($result);
            } else {
                // GET /channels
                $result = $service->getChannels();
                Helper::jsonResponse($result);
            }
            break;
            
        default:
            Helper::errorResponse('Method not allowed', 405);
    }
} catch (Exception $e) {
    error_log("Error in channels API: " . $e->getMessage());
    Helper::errorResponse($e->getMessage(), 500);
}

