<?php
require_once __DIR__ . '/../services/CategoriesService.php';
require_once __DIR__ . '/../utils/Helper.php';

$service = new CategoriesService();
$method = $_SERVER['REQUEST_METHOD'];
$uri = $_SERVER['REQUEST_URI'];

try {
    // Parse the URI to get the ID if present
    $uriParts = explode('/', trim(parse_url($uri, PHP_URL_PATH), '/'));
    $id = isset($uriParts[2]) && is_numeric($uriParts[2]) ? $uriParts[2] : null;
    
    switch ($method) {
        case 'GET':
            if ($id) {
                // GET /categories/:id
                $result = $service->getCategory($id);
                Helper::jsonResponse($result);
            } else {
                $showId = Helper::getQueryParam('showId');
                $onlyVisible = Helper::getQueryParam('onlyVisible', false);
                
                if ($showId) {
                    // GET /categories?showId=X
                    $result = $service->getCategoriesOfShow($showId);
                } else {
                    // GET /categories
                    $result = $service->getCategories($onlyVisible);
                }
                Helper::jsonResponse($result);
            }
            break;
            
        case 'POST':
            $body = Helper::getRequestBody();
            
            if (strpos($uri, '/add') !== false) {
                // POST /categories/add
                $service->addCategory($body);
                Helper::jsonResponse(['success' => true]);
            } else if (strpos($uri, '/update') !== false && $id) {
                // POST /categories/update/:id
                $service->updateCategory($id, $body);
                Helper::jsonResponse(['success' => true]);
            } else {
                Helper::errorResponse('Invalid endpoint', 404);
            }
            break;
            
        case 'DELETE':
            if (strpos($uri, '/delete') !== false && $id) {
                // DELETE /categories/delete/:id
                $service->deleteCategory($id);
                Helper::jsonResponse(['success' => true]);
            } else {
                Helper::errorResponse('Invalid endpoint', 404);
            }
            break;
            
        default:
            Helper::errorResponse('Method not allowed', 405);
    }
} catch (Exception $e) {
    error_log("Error in categories API: " . $e->getMessage());
    Helper::errorResponse($e->getMessage(), 500);
}

