# Quick Start Guide - Deploy to cPanel in 5 Minutes

## What You Need
- ✅ cPanel access
- ✅ MySQL database (already created)
- ✅ 5 minutes

## Step 1: Upload (2 minutes)
1. Zip the entire `server-php` folder
2. In cPanel → **File Manager** → `public_html`
3. Create folder named `api`
4. Upload and extract the ZIP file there

## Step 2: Configure Database (1 minute)
Edit `environments/production.env`:
```env
DB_HOST=localhost
DB_USER=your_db_username
DB_PASSWORD=your_db_password
DB_NAME=your_db_name
```

## Step 3: Set Permissions (30 seconds)
Right-click `storage` folder → Permissions → Set to **755**

## Step 4: Test (30 seconds)
Visit: `https://yourdomain.com/api/`

Should show:
```json
{"healthcheck":"ok"}
```

## Step 5: Update Mobile App (1 minute)
In your Ionic project, edit `src/environments/environment.prod.ts`:
```typescript
export const environment = {
  production: true,
  apiUrl: 'https://yourdomain.com/api'
};
```

## Done! 🎉

Your PHP backend is live and your mobile app will work without any code changes!

## Common Issues

**"Database connection failed"**
- Check database credentials in `production.env`
- Ensure database user has ALL PRIVILEGES

**"500 Error"**
- Check `error.log` file in your API folder
- Verify PHP version is 7.4+

**"404 Not Found"**
- Verify `.htaccess` file was uploaded
- Check if `RewriteBase` in `.htaccess` matches your directory

**Need detailed help?** → See `DEPLOYMENT_GUIDE.md`

