# cPanel Deployment Guide for Telemaroc PHP Backend

## Prerequisites

Before deploying, ensure you have:
- Access to cPanel
- A MySQL database already created in cPanel
- Database credentials (username, password, database name)
- Your database tables already imported/migrated

## Step-by-Step Deployment

### 1. Prepare Your Files

1. Zip all files from the `server-php` directory
2. Make sure you have these files:
   - `index.php`
   - `.htaccess`
   - `config.php`
   - `api/` folder with all endpoint files
   - `services/` folder with all service classes
   - `utils/` folder with Database.php and Helper.php
   - `environments/` folder with .env files

### 2. Upload to cPanel

#### Option A: Using File Manager (Recommended)

1. Log in to your cPanel
2. Click on **File Manager**
3. Navigate to `public_html`
4. Create a new folder called `api` (or your preferred name)
5. Enter the `api` folder
6. Click **Upload** in the toolbar
7. Upload your ZIP file
8. Once uploaded, right-click the ZIP file and select **Extract**
9. Delete the ZIP file after extraction

#### Option B: Using FTP

1. Connect to your hosting via FTP client (like FileZilla)
2. Navigate to `public_html`
3. Create a folder called `api`
4. Upload all files from `server-php` to this folder

### 3. Configure Database Connection

1. In cPanel File Manager, navigate to your API folder
2. Open `environments/production.env`
3. Click **Edit**
4. Update with your actual database credentials:

```env
DB_HOST=localhost
DB_PORT=3306
DB_USER=cpanel_username_dbuser
DB_PASSWORD=your_strong_password
DB_NAME=cpanel_username_dbname
CORS_ALLOWED_ORIGINS=*
```

**Note**: cPanel database usernames and database names are usually prefixed with your cPanel username (e.g., `myaccount_telemaroc`).

5. Save the file

### 4. Set Directory Permissions

1. In File Manager, right-click the `storage` folder
2. Select **Change Permissions**
3. Set to `755` (or `777` if 755 doesn't work)
4. Check "Recurse into subdirectories" if you have files inside
5. Click **Change Permissions**

### 5. Configure .htaccess

1. Open `.htaccess` file
2. If your API is in a subdirectory, update `RewriteBase`:

```apache
# If your API is at https://example.com/api/
RewriteBase /api/

# If your API is at root https://example.com/
RewriteBase /
```

3. Save the file

### 6. Verify Database Tables

Ensure your MySQL database has all required tables:
- `categories`
- `categories_shows`
- `channels`
- `episodes`
- `live_links`
- `program_live`
- `seasons`
- `shows`
- `social_networks`

You can check this in cPanel > phpMyAdmin.

### 7. Test Your API

1. Open your browser
2. Navigate to: `https://yourdomain.com/api/`
3. You should see:
   ```json
   {"healthcheck":"ok"}
   ```

4. Test a specific endpoint:
   - `https://yourdomain.com/api/categories`
   - Should return a list of categories

### 8. Update Mobile App

Update your Ionic mobile app to use the new PHP backend:

**File: `src/environments/environment.prod.ts`**
```typescript
export const environment = {
  production: true,
  apiUrl: 'https://yourdomain.com/api'
};
```

**File: `src/environments/environment.ts`**
```typescript
export const environment = {
  production: false,
  apiUrl: 'https://yourdomain.com/api'
};
```

### 9. Test Mobile App Connection

1. Build and run your mobile app
2. Test all features:
   - Load categories
   - View shows
   - Play episodes
   - Search functionality
   - Admin functions (if applicable)

## Common Issues and Solutions

### Issue 1: "500 Internal Server Error"

**Solution:**
1. Check if `.htaccess` file was uploaded
2. Check PHP error logs:
   - In cPanel, go to **Errors** under Metrics
   - Or check `error_log` file in your API directory
3. Verify PHP version is 7.4+ in cPanel > Select PHP Version

### Issue 2: "Database connection failed"

**Solution:**
1. Verify database credentials in `production.env`
2. In cPanel > MySQL Databases, ensure:
   - Database exists
   - User has ALL PRIVILEGES on the database
   - User is added to the database
3. Test connection in phpMyAdmin

### Issue 3: "404 Not Found" for all endpoints

**Solution:**
1. Verify `.htaccess` file exists
2. Check if `mod_rewrite` is enabled (contact host if needed)
3. Update `RewriteBase` in `.htaccess` to match your directory structure
4. Clear browser cache

### Issue 4: Upload not working

**Solution:**
1. Set `storage` folder permissions to 755 or 777
2. Check PHP upload limits:
   - In cPanel > Select PHP Version > Options
   - Increase `upload_max_filesize` to 50M
   - Increase `post_max_size` to 50M
3. Create `storage` directory if it doesn't exist

### Issue 5: CORS errors from mobile app

**Solution:**
1. Update `CORS_ALLOWED_ORIGINS` in `production.env`:
   ```env
   CORS_ALLOWED_ORIGINS=*
   ```
   Or specify your mobile app domain:
   ```env
   CORS_ALLOWED_ORIGINS=https://yourmobileapp.com,http://localhost:8100
   ```
2. Save and refresh

### Issue 6: "Access denied for user" error

**Solution:**
1. In cPanel > MySQL Databases
2. Under "Add User To Database":
   - Select your database user
   - Select your database
   - Click "Add"
3. On the next page, check "ALL PRIVILEGES"
4. Click "Make Changes"

## SSL/HTTPS Configuration

If your site uses HTTPS (recommended):

1. Ensure your SSL certificate is installed in cPanel
2. Add this to your `.htaccess` file (at the top, before other rules):

```apache
# Force HTTPS
RewriteCond %{HTTPS} off
RewriteRule ^(.*)$ https://%{HTTP_HOST}%{REQUEST_URI} [L,R=301]
```

## Performance Optimization

### Enable PHP OPcache

1. In cPanel > Select PHP Version
2. Click "Switch To PHP Options"
3. Find `opcache.enable` and set to `On`
4. Set `opcache.memory_consumption` to at least 128

### Enable Gzip Compression

Add to `.htaccess`:
```apache
# Enable Gzip Compression
<IfModule mod_deflate.c>
    AddOutputFilterByType DEFLATE text/html text/plain text/xml text/css text/javascript application/javascript application/json
</IfModule>
```

## Backup Recommendations

1. **Database Backup**:
   - In cPanel > Backup > Download a MySQL Database Backup
   - Schedule regular automated backups

2. **File Backup**:
   - Use cPanel Backup feature
   - Or download `storage` folder regularly (contains uploaded images)

## Monitoring

1. **Error Logs**:
   - Check `error.log` file regularly in your API directory
   - In cPanel > Errors (under Metrics)

2. **Resource Usage**:
   - Monitor in cPanel > Resource Usage
   - If you see high usage, consider optimization or upgrading plan

## Security Checklist

- ✅ Changed default database password
- ✅ Set proper file permissions (755 for directories, 644 for files)
- ✅ `.env` files are protected by `.htaccess`
- ✅ Using HTTPS (SSL certificate installed)
- ✅ CORS configured properly
- ✅ File upload validation in place
- ✅ Regular backups scheduled

## Getting Your Database Credentials

If you need to create a new database in cPanel:

1. Go to **MySQL Databases**
2. Under "Create New Database":
   - Enter database name (e.g., `telemaroc`)
   - Click "Create Database"
3. Under "Add New User":
   - Enter username (e.g., `telemaroc_user`)
   - Generate or enter a strong password
   - Click "Create User"
4. Under "Add User To Database":
   - Select the user you just created
   - Select the database you just created
   - Click "Add"
   - Grant "ALL PRIVILEGES"

Your credentials will be:
- **Host**: `localhost` or `127.0.0.1`
- **Username**: `cpaneluser_telemaroc_user` (prefixed with your cPanel username)
- **Password**: The password you set
- **Database**: `cpaneluser_telemaroc` (prefixed with your cPanel username)

## Final Testing Checklist

After deployment, test these endpoints:

- ✅ `GET /` - Returns healthcheck
- ✅ `GET /categories` - Returns categories
- ✅ `GET /shows` - Returns shows
- ✅ `GET /episodes` - Returns episodes
- ✅ `GET /search?keyword=test` - Returns search results
- ✅ `POST /upload` - Upload an image (test with Postman)
- ✅ Mobile app connects and loads data
- ✅ Admin panel works (if applicable)

## Need Help?

If you encounter issues:
1. Check PHP error logs
2. Verify database connection in phpMyAdmin
3. Test endpoints with Postman or curl
4. Contact your hosting provider if server features are missing

---

**Congratulations!** Your PHP backend is now deployed and ready to serve your Ionic mobile application.

